USE VoxcoSystem
GO
IF NOT EXISTS (SELECT 1 FROM sys.types WHERE is_table_type = 1 AND name = 'IdList')
BEGIN
	CREATE TYPE [dbo].[IdList]
	AS TABLE
	(
		Id INT NOT NULL
	);
END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Vx_sp_GetQuestionnairesState]') AND type in (N'P', N'PC'))
   DROP PROCEDURE [dbo].[Vx_sp_GetQuestionnairesState]
GO
CREATE PROCEDURE [dbo].[Vx_sp_GetQuestionnairesState]
    @questionnaireIds [dbo].[IdList] READONLY
AS
BEGIN
    SELECT [QuestID], [QuestState]
    FROM @questionnaireIds
    INNER JOIN [Questionnaire] ON [Id] = [QuestID];
END
GO
